/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.neoforge.coremods;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.neoforged.neoforge.coremods.CoremodUtils;
import net.neoforged.neoforgespi.transformation.ProcessorName;
import net.neoforged.neoforgespi.transformation.SimpleClassProcessor;
import net.neoforged.neoforgespi.transformation.SimpleTransformationContext;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodRedirector
extends SimpleClassProcessor {
    private final Map<String, List<MethodRedirection>> redirectionsByClass = new HashMap<String, List<MethodRedirection>>();
    private final Set<SimpleClassProcessor.Target> targets = new HashSet<SimpleClassProcessor.Target>();
    private static final List<MethodRedirection> REDIRECTIONS = List.of(new MethodRedirection(182, "finalizeSpawn", "(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/EntitySpawnReason;Lnet/minecraft/world/entity/SpawnGroupData;)Lnet/minecraft/world/entity/SpawnGroupData;", "finalize_spawn_targets.json", methodInsnNode -> new MethodInsnNode(184, "net/neoforged/neoforge/event/EventHooks", "finalizeMobSpawn", "(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/DifficultyInstance;Lnet/minecraft/world/entity/EntitySpawnReason;Lnet/minecraft/world/entity/SpawnGroupData;)Lnet/minecraft/world/entity/SpawnGroupData;", false)));

    public MethodRedirector() {
        for (MethodRedirection redirection : REDIRECTIONS) {
            String[] targetClassNames;
            for (String targetClassName : targetClassNames = CoremodUtils.loadResource(redirection.targetClassListFile, String[].class)) {
                this.targets.add(new SimpleClassProcessor.Target(targetClassName));
                List redirections = this.redirectionsByClass.computeIfAbsent(targetClassName, s -> new ArrayList());
                redirections.add(redirection);
            }
        }
    }

    public ProcessorName name() {
        return new ProcessorName("neoforge.coremods", "method_redirector");
    }

    public Set<SimpleClassProcessor.Target> targets() {
        return this.targets;
    }

    public void transform(ClassNode classNode, SimpleTransformationContext context) {
        List redirections = this.redirectionsByClass.getOrDefault(context.type().getClassName(), Collections.emptyList());
        List methods = classNode.methods;
        for (MethodNode method : methods) {
            InsnList instr = method.instructions;
            for (int i = 0; i < instr.size(); ++i) {
                AbstractInsnNode node = instr.get(i);
                if (!(node instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)node;
                for (MethodRedirection redirection : redirections) {
                    if (redirection.invokeOpCode != methodInsnNode.getOpcode() || !redirection.methodName.equals(methodInsnNode.name) || !redirection.methodDescriptor.equals(methodInsnNode.desc)) continue;
                    instr.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)redirection.redirector.apply(methodInsnNode));
                }
            }
        }
    }

    private record MethodRedirection(int invokeOpCode, String methodName, String methodDescriptor, String targetClassListFile, Function<MethodInsnNode, MethodInsnNode> redirector) {
    }
}

